% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rlassoIV.R
\name{rlassoIV}
\alias{rlassoIV}
\alias{rlassoIVmult}
\title{Post-Selection and Post-Regularization Inference in Linear Models with Many
Controls and Instruments}
\usage{
rlassoIV(x, d, y, z, select.Z = TRUE, select.X = TRUE, post = TRUE, ...)

rlassoIVmult(x, d, y, z, select.Z = TRUE, select.X = TRUE, ...)
}
\arguments{
\item{x}{matrix of exogenous variables}

\item{d}{endogenous variable}

\item{y}{outcome / dependent variable (vector or matrix)}

\item{z}{matrix of instrumental variables}

\item{select.Z}{logical, indicating selection on the instruments}

\item{select.X}{logical, indicating selection on the exogenous variables}

\item{post}{logical, wheter post-Lasso should be conducted (default=\code{TRUE})}

\item{\dots}{arguments passed to the function \code{rlasso}}
}
\value{
an object of class \code{rlassoIV} containing at least the following
components: \item{coefficients}{estimated parameter value}
\item{se}{variance-covariance matrix}
}
\description{
The function estimates a treatment effect in a setting with very many
controls and very many instruments (even larger than the sample size).
}
\details{
The implementation for selection on x and z follows the procedure described in Chernozhukov et al.
(2015) and is built on 'triple selection' to achieve an orthogonal moment
function. The function returns an object of S3 class \code{rlassoIV}.
Moreover, it is wrap function for the case that selection should be done only with the instruments Z (\code{rlassoIVselectZ}) or with
the control variables X (\code{rlassoIVselectX}) or without selection (\code{tsls}).
}
\references{
V. Chernozhukov, C. Hansen, M. Spindler (2015). Post-selection
and post-regularization inference in linear models with many controls and
instruments. American Economic Review: Paper & Proceedings 105(5), 486--490.
}
\keyword{Instrumental}
\keyword{Lasso}
\keyword{Many}
\keyword{Variable}
\keyword{and}
\keyword{controls}
\keyword{instruments}

