% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/high_level_UI.R
\name{H5S_H5D_subset_assign}
\alias{H5S_H5D_subset_assign}
\alias{subset_h5.H5S}
\alias{[.H5S}
\alias{subset_h5.H5D}
\alias{[.H5D}
\alias{subset_assign_h5.H5D}
\alias{[<-.H5D}
\title{Selecting and assigning subsets of HDF5-Spaces and HDF5-Datasets}
\usage{
subset_h5.H5S(x, d1, ..., op = h5const$H5S_SELECT_SET,
  envir = parent.frame())

\method{[}{H5S}(x, d1, ..., op = h5const$H5S_SELECT_SET,
  envir = parent.frame())

subset_h5.H5D(x, d1, ..., dataset_xfer_pl = h5const$H5P_DEFAULT,
  flags = getOption("hdf5r.h5tor_default"), drop = TRUE,
  envir = parent.frame())

\method{[}{H5D}(x, d1, ..., dataset_xfer_pl = h5const$H5P_DEFAULT,
  flags = getOption("hdf5r.h5tor_default"), drop = TRUE,
  envir = parent.frame())

subset_assign_h5.H5D(x, d1, ..., dataset_xfer_pl = h5const$H5P_DEFAULT,
  envir = parent.frame(), value)

\method{[}{H5D}(x, d1, ..., dataset_xfer_pl = h5const$H5P_DEFAULT,
  envir = parent.frame()) <- value
}
\arguments{
\item{x}{The  \code{\link{H5S}} or \code{\link{H5D}} to subset or assign values to}

\item{d1}{First dimension of the object}

\item{...}{Used for other dimension of the object}

\item{op}{Operation to perform on the \code{\link{H5S}}. Look into the HDF5 online help
\url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5S.html#Dataspace-SelectElements} and
\url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5S.html#Dataspace-SelectHyperslab}}

\item{envir}{The environment in which the dimension indices \code{d1, ...} are to be evaluated. Usually the environment from
where the function is called}

\item{dataset_xfer_pl}{An object of class \code{\link{H5P_DATASET_XFER}}.}

\item{flags}{Some flags governing edge cases of conversion from HDF5 to R. This is related to how integers are being treated and
the issue of R not being able to natively represent 64bit integers and not at all being able to represent unsigned 64bit integers
(even using add-on packages). The constants governing this are part of \code{\link{h5const}}. The relevant ones start with the term
\code{H5TOR} and are documented there. The default set here returns a regular 32bit integer if it doesn't lead to an overflow
and returns a 64bit integer from the \code{bit64} package otherwise. For 64bit unsigned int that are larger than 64bit signed int,
it return a \code{double}. This looses precision, however. See also documentation or \code{\link{h5const}}.}

\item{drop}{Logical. When reading data, should dimensions of size 1 be dropped.}

\item{value}{The value to assign to the dataset}
}
\value{
For \code{x} being a \code{\link{H5S}}, the same object is returned, but with the selection set as requested. For
\code{\link{H5D}} it retrieves the subset of data requested or sets the subset of data assigned, as for any n-dimensional array
in R.
}
\description{
Selecting and assigning subsets of HDF5-Spaces and HDF5-Datasets
}
\details{
Used for subsetting HDF5-Datasets or HDF5-Spaces or for assigning data into HDF5-Datasets. There are some differences to
consider with R itself.

Most importantly HDF5-COMPOUND objects only have a single dimension internally to HDF5 (a vector), but they correspond to R-data.frames,
which are 2 dimensional. For an HDF5 COMPOUND object, it is currently not possible to only sub-select a specific column.
All columns have to be extracted (using 1-dimensional access with \code{[} and can then be subset in R itself.
The same is true for writing a COMPOUND object (\code{\link{H5T_COMPOUND}}). A complete data-frame
is needed, not just a subset of the columns.

Another important differences is for datasets of HDF5-ARRAY type \code{\link{H5T_ARRAY}}
where the access to the object is only for the dimension of the object itself, not including the dimensions of the underlying array type.
}
\author{
Holger Hoefling
}
