// (c) The HDF Group
#if !(defined H5P_FRIEND || defined H5P_MODULE)
#error "Do not include this file outside the H5P package!"
#endif
#ifndef H5Ppkg_H
#define H5Ppkg_H
#include "H5Pprivate.h"
#include "H5SLprivate.h"
typedef enum {
    H5P_PROP_WITHIN_UNKNOWN = 0,
    H5P_PROP_WITHIN_LIST,
    H5P_PROP_WITHIN_CLASS
} H5P_prop_within_t;
typedef enum {
    H5P_MOD_ERR = (-1),
    H5P_MOD_INC_CLS,
    H5P_MOD_DEC_CLS,
    H5P_MOD_INC_LST,
    H5P_MOD_DEC_LST,
    H5P_MOD_INC_REF,
    H5P_MOD_DEC_REF,
    H5P_MOD_MAX
} H5P_class_mod_t;
typedef struct H5P_genprop_t {
    char             *name;
    size_t            size;
    void             *value;
    H5P_prop_within_t type;
    bool shared_name;
    H5P_prp_create_func_t  create;
    H5P_prp_set_func_t     set;
    H5P_prp_get_func_t     get;
    H5P_prp_encode_func_t  encode;
    H5P_prp_decode_func_t  decode;
    H5P_prp_delete_func_t  del;
    H5P_prp_copy_func_t    copy;
    H5P_prp_compare_func_t cmp;
    H5P_prp_close_func_t   close;
} H5P_genprop_t;
struct H5P_genclass_t {
    struct H5P_genclass_t *parent;
    char                  *name;
    H5P_plist_type_t       type;
    size_t                 nprops;
    unsigned
        plists;
    unsigned classes;
    unsigned ref_count;
    bool     deleted;
    unsigned revision;
    H5SL_t  *props;
    H5P_cls_create_func_t create_func;
    void                 *create_data;
    H5P_cls_copy_func_t   copy_func;
    void                 *copy_data;
    H5P_cls_close_func_t  close_func;
    void                 *close_data;
};
struct H5P_genplist_t {
    H5P_genclass_t *pclass;
    hid_t           plist_id;
    size_t          nprops;
    bool            class_init;
    H5SL_t         *del;
    H5SL_t         *props;
};
typedef int (*H5P_iterate_int_t)(H5P_genprop_t *prop, void *udata);
struct H5Z_filter_info_t;
H5_DLL H5P_genclass_t *H5P__create_class(H5P_genclass_t *par_class, const char *name, H5P_plist_type_t type,
                                         H5P_cls_create_func_t cls_create, void *create_data,
                                         H5P_cls_copy_func_t cls_copy, void *copy_data,
                                         H5P_cls_close_func_t cls_close, void *close_data);
H5_DLL H5P_genclass_t *H5P__copy_pclass(H5P_genclass_t *pclass);
H5_DLL herr_t H5P__register_real(H5P_genclass_t *pclass, const char *name, size_t size, const void *def_value,
                                 H5P_prp_create_func_t prp_create, H5P_prp_set_func_t prp_set,
                                 H5P_prp_get_func_t prp_get, H5P_prp_encode_func_t prp_encode,
                                 H5P_prp_decode_func_t prp_decode, H5P_prp_delete_func_t prp_delete,
                                 H5P_prp_copy_func_t prp_copy, H5P_prp_compare_func_t prp_cmp,
                                 H5P_prp_close_func_t prp_close);
H5_DLL herr_t H5P__register(H5P_genclass_t **pclass, const char *name, size_t size, const void *def_value,
                            H5P_prp_create_func_t prp_create, H5P_prp_set_func_t prp_set,
                            H5P_prp_get_func_t prp_get, H5P_prp_encode_func_t prp_encode,
                            H5P_prp_decode_func_t prp_decode, H5P_prp_delete_func_t prp_delete,
                            H5P_prp_copy_func_t prp_copy, H5P_prp_compare_func_t prp_cmp,
                            H5P_prp_close_func_t prp_close);
H5_DLL herr_t H5P__add_prop(H5SL_t *props, H5P_genprop_t *prop);
H5_DLL herr_t H5P__access_class(H5P_genclass_t *pclass, H5P_class_mod_t mod);
H5_DLL herr_t H5P__class_get(const H5P_genclass_t *pclass, const char *name, void *value);
H5_DLL herr_t H5P__class_set(const H5P_genclass_t *pclass, const char *name, const void *value);
H5_DLL htri_t H5P__exist_pclass(H5P_genclass_t *pclass, const char *name);
H5_DLL herr_t H5P__get_size_plist(const H5P_genplist_t *plist, const char *name, size_t *size);
H5_DLL herr_t H5P__get_size_pclass(H5P_genclass_t *pclass, const char *name, size_t *size);
H5_DLL herr_t H5P__get_nprops_plist(const H5P_genplist_t *plist, size_t *nprops);
H5_DLL int    H5P__cmp_class(const H5P_genclass_t *pclass1, const H5P_genclass_t *pclass2);
H5_DLL herr_t H5P__cmp_plist(const H5P_genplist_t *plist1, const H5P_genplist_t *plist2, int *cmp_ret);
H5_DLL int    H5P__iterate_plist(const H5P_genplist_t *plist, bool iter_all_prop, int *idx,
                                 H5P_iterate_int_t iter_func, void *iter_data);
H5_DLL int    H5P__iterate_pclass(const H5P_genclass_t *pclass, int *idx, H5P_iterate_int_t iter_func,
                                  void *iter_data);
H5_DLL herr_t H5P__copy_prop_plist(hid_t dst_id, hid_t src_id, const char *name);
H5_DLL herr_t H5P__copy_prop_pclass(hid_t dst_id, hid_t src_id, const char *name);
H5_DLL herr_t H5P__unregister(H5P_genclass_t *pclass, const char *name);
H5_DLL char  *H5P__get_class_path(H5P_genclass_t *pclass);
H5_DLL H5P_genclass_t *H5P__open_class_path(const char *path);
H5_DLL H5P_genclass_t *H5P__get_class_parent(const H5P_genclass_t *pclass);
H5_DLL herr_t          H5P__close_class(H5P_genclass_t *pclass);
H5_DLL H5P_genprop_t  *H5P__find_prop_plist(const H5P_genplist_t *plist, const char *name);
H5_DLL hid_t           H5P__new_plist_of_type(H5P_plist_type_t type);
H5_DLL herr_t H5P__encode(const H5P_genplist_t *plist, bool enc_all_prop, void *buf, size_t *nalloc);
H5_DLL hid_t  H5P__decode(const void *buf);
H5_DLL herr_t H5P__encode_hsize_t(const void *value, void **_pp, size_t *size);
H5_DLL herr_t H5P__encode_size_t(const void *value, void **_pp, size_t *size);
H5_DLL herr_t H5P__encode_unsigned(const void *value, void **_pp, size_t *size);
H5_DLL herr_t H5P__encode_uint8_t(const void *value, void **_pp, size_t *size);
H5_DLL herr_t H5P__encode_bool(const void *value, void **_pp, size_t *size);
H5_DLL herr_t H5P__encode_double(const void *value, void **_pp, size_t *size);
H5_DLL herr_t H5P__encode_uint64_t(const void *value, void **_pp, size_t *size);
H5_DLL herr_t H5P__decode_hsize_t(const void **_pp, void *value);
H5_DLL herr_t H5P__decode_size_t(const void **_pp, void *value);
H5_DLL herr_t H5P__decode_unsigned(const void **_pp, void *value);
H5_DLL herr_t H5P__decode_uint8_t(const void **_pp, void *value);
H5_DLL herr_t H5P__decode_bool(const void **_pp, void *value);
H5_DLL herr_t H5P__decode_double(const void **_pp, void *value);
H5_DLL herr_t H5P__decode_uint64_t(const void **_pp, void *value);
H5_DLL herr_t H5P__encode_coll_md_read_flag_t(const void *value, void **_pp, size_t *size);
H5_DLL herr_t H5P__decode_coll_md_read_flag_t(const void **_pp, void *value);
H5_DLL herr_t H5P__facc_set_def_driver(void);
H5_DLL herr_t H5P__get_filter(const struct H5Z_filter_info_t *filter, unsigned int *flags, size_t *cd_nelmts,
                              unsigned cd_values[], size_t namelen, char name[], unsigned *filter_config);
#ifdef H5P_TESTING
H5_DLL char *H5P__get_class_path_test(hid_t pclass_id);
H5_DLL hid_t H5P__open_class_path_test(const char *path);
#endif
#endif
