// (c) The HDF Group
#ifndef H5FDioc_priv_H
#define H5FDioc_priv_H
#include <stdatomic.h>
#include "H5private.h"
#include "H5CXprivate.h"
#include "H5Dprivate.h"
#include "H5Eprivate.h"
#include "H5FDioc.h"
#include "H5Iprivate.h"
#include "H5MMprivate.h"
#include "H5Pprivate.h"
#include "H5subfiling_common.h"
#include "mercury_thread.h"
#include "mercury_thread_mutex.h"
#include "mercury_thread_pool.h"
#define H5FD_IOC__IO_Q_ENTRY_MAGIC 0x1357
#define H5FD_IOC__Q_APPEND(q_ptr, entry_ptr)                                                      \
do {                                                                                              \
    assert(q_ptr);                                                                              \
    assert((q_ptr)->magic == H5FD_IOC__IO_Q_MAGIC);                                             \
    assert((((q_ptr)->q_len == 0) && ((q_ptr)->q_head == NULL) && ((q_ptr)->q_tail == NULL)) || \
             (((q_ptr)->q_len > 0) && ((q_ptr)->q_head != NULL) && ((q_ptr)->q_tail != NULL)));   \
    assert(entry_ptr);                                                                          \
    assert((entry_ptr)->magic == H5FD_IOC__IO_Q_ENTRY_MAGIC);                                   \
    assert((entry_ptr)->next == NULL);                                                          \
    assert((entry_ptr)->prev == NULL);                                                          \
    assert((entry_ptr)->in_progress == false);                                                  \
                                                                                                  \
    if ( ((q_ptr)->q_head) == NULL )                                                              \
    {                                                                                             \
       ((q_ptr)->q_head) = (entry_ptr);                                                           \
       ((q_ptr)->q_tail) = (entry_ptr);                                                           \
    }                                                                                             \
    else                                                                                          \
    {                                                                                             \
       ((q_ptr)->q_tail)->next = (entry_ptr);                                                     \
       (entry_ptr)->prev = ((q_ptr)->q_tail);                                                     \
       ((q_ptr)->q_tail) = (entry_ptr);                                                           \
    }                                                                                             \
    ((q_ptr)->q_len)++;                                                                           \
} while ( false )
#define H5FD_IOC__Q_REMOVE(q_ptr, entry_ptr)                                                                         \
do {                                                                                                                 \
    assert(q_ptr);                                                                                                 \
    assert((q_ptr)->magic == H5FD_IOC__IO_Q_MAGIC);                                                                \
    assert((((q_ptr)->q_len == 1) && ((q_ptr)->q_head ==((q_ptr)->q_tail)) && ((q_ptr)->q_head == (entry_ptr))) || \
             (((q_ptr)->q_len > 0) && ((q_ptr)->q_head != NULL) && ((q_ptr)->q_tail != NULL)));                      \
    assert(entry_ptr);                                                                                             \
    assert((entry_ptr)->magic == H5FD_IOC__IO_Q_ENTRY_MAGIC);                                                      \
    assert((((q_ptr)->q_len == 1) && ((entry_ptr)->next == NULL) && ((entry_ptr)->prev == NULL)) ||                \
             (((q_ptr)->q_len > 1) && (((entry_ptr)->next != NULL) || ((entry_ptr)->prev != NULL))));                \
    assert((entry_ptr)->in_progress == true);                                                                      \
                                                                                                                     \
    {                                                                                                                \
       if ( (((q_ptr)->q_head)) == (entry_ptr) )                                                                     \
       {                                                                                                             \
          (((q_ptr)->q_head)) = (entry_ptr)->next;                                                                   \
          if ( (((q_ptr)->q_head)) != NULL )                                                                         \
             (((q_ptr)->q_head))->prev = NULL;                                                                       \
       }                                                                                                             \
       else                                                                                                          \
       {                                                                                                             \
          (entry_ptr)->prev->next = (entry_ptr)->next;                                                               \
       }                                                                                                             \
       if (((q_ptr)->q_tail) == (entry_ptr) )                                                                        \
       {                                                                                                             \
          ((q_ptr)->q_tail) = (entry_ptr)->prev;                                                                     \
          if ( ((q_ptr)->q_tail) != NULL )                                                                           \
             ((q_ptr)->q_tail)->next = NULL;                                                                         \
       }                                                                                                             \
       else                                                                                                          \
       {                                                                                                             \
          (entry_ptr)->next->prev = (entry_ptr)->prev;                                                               \
       }                                                                                                             \
       (entry_ptr)->next = NULL;                                                                                     \
       (entry_ptr)->prev = NULL;                                                                                     \
       ((q_ptr)->q_len)--;                                                                                           \
    }                                                                                                                \
} while ( false )
typedef struct ioc_io_queue_entry {
    uint32_t                   magic;
    struct ioc_io_queue_entry *next;
    struct ioc_io_queue_entry *prev;
    bool                       in_progress;
    uint32_t                   counter;
    sf_work_request_t     wk_req;
    struct hg_thread_work thread_wk;
    int                   wk_ret;
#ifdef H5FD_IOC_COLLECT_STATS
    uint64_t q_time;
    uint64_t dispatch_time;
#endif
} ioc_io_queue_entry_t;
#define H5FD_IOC__IO_Q_MAGIC 0x2468
typedef struct ioc_io_queue {
    uint32_t              magic;
    ioc_io_queue_entry_t *q_head;
    ioc_io_queue_entry_t *q_tail;
    int32_t               num_pending;
    int32_t               num_in_progress;
    int32_t               num_failed;
    int32_t               q_len;
    uint32_t              req_counter;
    hg_thread_mutex_t     q_mutex;
#ifdef H5FD_IOC_COLLECT_STATS
    int32_t max_q_len;
    int32_t max_num_pending;
    int32_t max_num_in_progress;
    int64_t ind_read_requests;
    int64_t ind_write_requests;
    int64_t truncate_requests;
    int64_t get_eof_requests;
    int64_t requests_queued;
    int64_t requests_dispatched;
    int64_t requests_completed;
#endif
} ioc_io_queue_t;
typedef struct _io_req {
    int         ioc;
    int64_t     context_id;
    int64_t     offset;
    int64_t     elements;
    void       *data;
    MPI_Request io_transfer_req;
    MPI_Request io_comp_req;
    int         io_comp_tag;
} io_req_t;
extern int *H5FD_IOC_tag_ub_val_ptr;
#ifdef __cplusplus
extern "C" {
#endif
H5_DLL herr_t H5FD__ioc_init_threads(void *_sf_context);
H5_DLL herr_t H5FD__ioc_finalize_threads(void *_sf_context);
H5_DLL herr_t H5FD__ioc_write_independent_async(int64_t context_id, int64_t offset, int64_t elements,
                                                const void *data, io_req_t **io_req);
H5_DLL herr_t H5FD__ioc_read_independent_async(int64_t context_id, int64_t offset, int64_t elements,
                                               void *data, io_req_t **io_req);
H5_DLL herr_t H5FD__ioc_async_completion(MPI_Request *mpi_reqs, size_t num_reqs);
#ifdef __cplusplus
}
#endif
#endif
