% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family.R
\name{family.mixturecure}
\alias{family.mixturecure}
\title{Return model family and fitting algorithm for mixturecure model fits}
\usage{
\method{family}{mixturecure}(object, ...)
}
\arguments{
\item{object}{an object of class \code{mixturecure}}

\item{...}{other arguments.}
}
\value{
the parametric or semi-parametric model fit and the fitting
algorithm.
}
\description{
Return model family and fitting algorithm for\code{mixturecure}
model fits.
}
\examples{
library(survival)
withr::local_seed(1234)
temp <- generate_cure_data(n = 100, j = 10, n_true = 10, a = 1.8)
training <- temp$training
fit <- curegmifs(Surv(Time, Censor) ~ .,
  data = training, x_latency = training,
  model = "weibull", thresh = 1e-4, maxit = 2000,
  epsilon = 0.01, verbose = FALSE
)
family(fit)
}
\keyword{methods}
