% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constituencies.R
\name{constituencies}
\alias{constituencies}
\alias{hansard_constituencies}
\title{House of Commons constituencies}
\usage{
constituencies(current = NULL, extra_args = NULL, tidy = TRUE,
  tidy_style = "snake_case", verbose = TRUE)

hansard_constituencies(current = NULL, extra_args = NULL,
  tidy = TRUE, tidy_style = "snake_case", verbose = TRUE)
}
\arguments{
\item{current}{If \code{TRUE}, returns only current constituencies. If
\code{FALSE}, returns only former constituencies. If \code{NULL}, returns
all current and former constituencies. Defaults to \code{NULL}.}

\item{extra_args}{Additional parameters and queries to pass to API. These
queries must be strings and start with "&". See the
\href{http://explore.data.parliament.uk/}{API documentation}
or the package vignette for more details. Defaults to \code{NULL}.}

\item{tidy}{Logical parameter. If \code{TRUE}, fixes the variable names
in the tibble to remove special characters and superfluous text, and
converts the variable names to a consistent style. Defaults to \code{TRUE}.}

\item{tidy_style}{The style to convert variable names to, if
\code{tidy = TRUE}. Accepts one of \code{'snake_case'}, \code{'camelCase'}
and \code{'period.case'}. Defaults to \code{'snake_case'}.}

\item{verbose}{If \code{TRUE}, displayes messages on the console on the
progress of the API request. Defaults to \code{TRUE}.}
}
\value{
A tibble with details of Westminster constituencies.
}
\description{
Imports data on House of Commons constituencies, returning a tibble of all
current and/or former Westminster constituencies, subject to parameters.
}
\examples{
\dontrun{
x <- constituencies()

y <- constituencies(current = FALSE)
}

}
