% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReformatDataframe.R
\name{modifyColNames}
\alias{modifyColNames}
\title{Return reformatted data.frame with standard col names}
\usage{
modifyColNames(rawDataFrame, cols = TRUE, rawSep = "..", sep = "_")
}
\arguments{
\item{rawDataFrame}{Raw data.frame input}

\item{cols}{Specific col names or indexes what you want to reformat (default: TRUE, use all cols)}

\item{rawSep}{Raw odd separation symbol in col names of raw data.frame.
Note: it supports regEx (regular expression), so "." means all possible symbols.
If you want to use the "." dot notation, please use "[.]".}

\item{sep}{Separation symbol in col names of modified data.frame}
}
\value{
A modified data.frame with col names separated by your given delimitator
}
\description{
Return reformatted data.frame with standard col names
}
\examples{
library(handyFunctions)
data(people)
modified_people <- modifyColNames(people,rawSep = "[.][.]")

}
