% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_templates.R
\name{make_clustering_template}
\alias{make_clustering_template}
\title{Make Clustering Template}
\usage{
make_clustering_template(
  main_dir,
  template_docs,
  writer_indices,
  centers_seed,
  K = 40,
  num_dist_cores = 1,
  max_iters = 25
)
}
\arguments{
\item{main_dir}{Main directory that will store template files}

\item{template_docs}{A directory containing template training images}

\item{writer_indices}{A vector of the starting and ending location of the
writer ID in the file name.}

\item{centers_seed}{Integer seed for the random number generator when
selecting starting cluster centers.}

\item{K}{Integer number of clusters}

\item{num_dist_cores}{Integer number of cores to use for the distance
calculations in the K-means algorithm. Each iteration of the K-means
algorithm calculates the distance between each input graph and each cluster
center.}

\item{max_iters}{Maximum number of iterations to allow the K-means algorithm
to run}
}
\value{
List containing the cluster template
}
\description{
\code{make_clustering_template()} applies a K-means clustering algorithm to the
input handwriting samples pre-processed with \code{\link[=process_batch_dir]{process_batch_dir()}} and saved
in the input folder \verb{main_dir > data > template_graphs}. The K-means
algorithm sorts the graphs in the input handwriting samples into groups, or
\emph{clusters}, of similar graphs.
}
\examples{
\dontrun{
main_dir <- "path/to/folder"
template_docs <- system.file("extdata/example_images/template_training_images",
  package = "handwriter"
)
template_list <- make_clustering_template(
  main_dir = main_dir,
  template_docs = template_docs,
  writer_indices = c(2, 5),
  K = 10,
  num_dist_cores = 2,
  max_iters = 25,
  centers_seed = 100,
)
}

}
