% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_gene.R
\name{summarize_gene}
\alias{summarize_gene}
\title{Calculate and Summarize Distribution of Susceptibilities by Gene}
\usage{
summarize_gene(x, cutoff, control, sample, gene, perc_susc)
}
\arguments{
\item{x}{a \code{data.frame} containing the data.}

\item{cutoff}{value for percent susceptible cutoff. Numeric.}

\item{control}{value used to denote the susceptible control in the \code{gene}
field. Character.}

\item{sample}{field providing the unique identification for each sample being
tested. Character.}

\item{gene}{field providing the gene(s) being tested. Character.}

\item{perc_susc}{field providing the percent susceptible reactions.
Character.}
}
\value{
returns an object of \code{\link[=class]{class()}} \code{hagis.gene.summary}
An object of class \code{hagis.summaries} is a\cr \code{\link[data.table:data.table]{data.table::data.table()}}
containing the following components fields
\describe{
\item{gene}{the gene}
\item{N_susc}{the total number susceptible for a given gene in the
gene field}
\item{percent_pathogenic}{the frequency with which a gene is pathogenic}
}
}
\description{
This function will calculate the distribution of
susceptibilities by gene.
}
\examples{

# locate system file for import
Ps <- system.file("extdata", "practice_data_set.csv", package = "hagis")

# import 'practice_data_set.csv'
Ps <- read.csv(Ps)
head(Ps)

# calculate susceptibilities with a 60 \% cutoff value
susc <- summarize_gene(x = Ps,
                     cutoff = 60,
                     control = "susceptible",
                     sample = "Isolate",
                     gene = "Rps",
                     perc_susc = "perc.susc")
susc

# plot susceptibilities
plot(susc, type = "percentage")

}
