% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster2Graph.R
\name{raster2Graph}
\alias{raster2Graph}
\title{Create a graph from an raster according the connection between cells}
\usage{
raster2Graph(r, cellsize = NULL, relative.distance = TRUE, silent = TRUE)
}
\arguments{
\item{r}{An object of stars or RasterLayer. The value of each cell of the raster is the ‘smoothness’ to indicate how easy the cell connecting with neighbor cells.}

\item{cellsize}{Numeric. Re-sample the input raster to given resolution and use the re-sampled raster to build graph. Set this to NULL if using the original resolution of of the input raster.}

\item{relative.distance}{Boolean. If fasle, absolute distance between cells is used to compute the edge weight; otherwise, relative distance between cells is used. Default is true}

\item{silent}{Boolean. A logical indicating if some “progress report” should be given. Default is TRUE.}
}
\value{
a list with an graph and the re-sampled raster (a object of stars). The graph is igraph object, with cells as node and connections as weight.
}
\description{
Create a graph from an raster according the connection between cells
}
\examples{
# read in habitat suitability data of wolf in Europe
library(stars)
hsi.file = system.file("extdata","wolf3_int.tif",package="habCluster")
wolf = read_stars(hsi.file)
# build graph from raster
g = raster2Graph(wolf, 40000)
}
