% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kvstore.R
\name{h2o.rm}
\alias{h2o.rm}
\title{Delete Objects In H2O}
\usage{
h2o.rm(ids, cascade = TRUE)
}
\arguments{
\item{ids}{The object or hex key associated with the object to be removed or a vector/list of those things.}

\item{cascade}{Boolean, if set to TRUE (default), the object dependencies (e.g. submodels) are also removed.}
}
\description{
Remove the h2o Big Data object(s) having the key name(s) from ids.
}
\examples{
\dontrun{
library(h2o)
h2o.init()
iris <- as.h2o(iris)
model <- h2o.glm(1:4,5,training = iris, family = "multinomial")
h2o.rm(iris)
}
}
\seealso{
\code{\link{h2o.assign}}, \code{\link{h2o.ls}}
}
