% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.R
\name{h2o.learning_curve_plot}
\alias{h2o.learning_curve_plot}
\title{Learning Curve Plot}
\usage{
h2o.learning_curve_plot(
  model,
  metric = c("AUTO", "auc", "aucpr", "mae", "rmse", "anomaly_score", "convergence",
    "custom", "custom_increasing", "deviance", "lift_top_group", "logloss",
    "misclassification", "negative_log_likelihood", "objective", "sumetaieta02"),
  cv_ribbon = NULL,
  cv_lines = NULL
)
}
\arguments{
\item{model}{an H2O model}

\item{metric}{Metric to be used for the learning curve plot. These should mostly correspond with stopping metric.}

\item{cv_ribbon}{if True, plot the CV mean as a and CV standard deviation as a ribbon around the mean,
if NULL, it will attempt to automatically determine if this is suitable visualisation}

\item{cv_lines}{if True, plot scoring history for individual CV models, if NULL, it will attempt to
automatically determine if this is suitable visualisation}
}
\value{
A ggplot2 object
}
\description{
Create learning curve plot for an H2O Model. Learning curves show error metric dependence on
learning progress, e.g., RMSE vs number of trees trained so far in GBM. There can be up to 4 curves
showing Training, Validation, Training on CV Models, and Cross-validation error.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

# Import the wine dataset into H2O:
f <- "https://h2o-public-test-data.s3.amazonaws.com/smalldata/wine/winequality-redwhite-no-BOM.csv"
df <-  h2o.importFile(f)

# Set the response
response <- "quality"

# Split the dataset into a train and test set:
splits <- h2o.splitFrame(df, ratios = 0.8, seed = 1)
train <- splits[[1]]
test <- splits[[2]]

# Build and train the model:
gbm <- h2o.gbm(y = response,
               training_frame = train)

# Create the learning curve plot
learning_curve <- h2o.learning_curve_plot(gbm)
print(learning_curve)
}
}
