% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kvstore.R
\name{h2o.getFrame}
\alias{h2o.getFrame}
\title{Get an R Reference to an H2O Dataset, that will NOT be GC'd by default}
\usage{
h2o.getFrame(id)
}
\arguments{
\item{id}{A string indicating the unique frame of the dataset to retrieve.}
}
\description{
Get the reference to a frame with the given id in the H2O instance.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

f <- "http://h2o-public-test-data.s3.amazonaws.com/smalldata/iris/iris_train.csv"
train <- h2o.importFile(f)
y <- "species"
x <- setdiff(names(train), y)
train[, y] <- as.factor(train[, y])
nfolds <- 5
num_base_models <- 2
my_gbm <- h2o.gbm(x = x, y = y, training_frame = train, 
                  distribution = "multinomial", ntrees = 10, 
                  max_depth = 3, min_rows = 2, learn_rate = 0.2, 
                  nfolds = nfolds, fold_assignment = "Modulo", 
                  keep_cross_validation_predictions = TRUE, seed = 1)
my_rf <- h2o.randomForest(x = x, y = y, training_frame = train, 
                          ntrees = 50, nfolds = nfolds, fold_assignment = "Modulo", 
                          keep_cross_validation_predictions = TRUE, seed = 1)
stack <- h2o.stackedEnsemble(x = x, y = y, training_frame = train, 
                             model_id = "my_ensemble_l1", 
                             base_models = list(my_gbm@model_id, my_rf@model_id), 
                             keep_levelone_frame = TRUE)
h2o.getFrame(stack@model$levelone_frame_id$name)
}
}
