% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.centroid_stats}
\alias{h2o.centroid_stats}
\title{Retrieve centroid statistics}
\usage{
h2o.centroid_stats(object, train = FALSE, valid = FALSE, xval = FALSE)
}
\arguments{
\item{object}{An \linkS4class{H2OClusteringModel} object.}

\item{train}{Retrieve the training centroid statistics}

\item{valid}{Retrieve the validation centroid statistics}

\item{xval}{Retrieve the cross-validation centroid statistics}
}
\description{
Retrieve the centroid statistics.
If "train", "valid", and "xval" parameters are FALSE (default), then the training centroid stats value is returned. If more
than one parameter is set to TRUE, then a named list of centroid stats data frames are returned, where the names are "train", "valid"
or "xval".
}
\examples{
\dontrun{
library(h2o)
h2o.init()
fr <- h2o.importFile("http://h2o-public-test-data.s3.amazonaws.com/smalldata/iris/iris_train.csv")
predictors <- c("sepal_len", "sepal_wid", "petal_len", "petal_wid")
km <- h2o.kmeans(x = predictors, training_frame = fr, k = 3, nfolds = 3)
h2o.centroid_stats(km, train = TRUE)
}
}
