% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.pivot}
\alias{h2o.pivot}
\title{Pivot a frame}
\usage{
h2o.pivot(x, index, column, value)
}
\arguments{
\item{x}{an H2OFrame}

\item{index}{the column where pivoted rows should be aligned on}

\item{column}{the column to pivot}

\item{value}{values of the pivoted table}
}
\value{
An H2OFrame with columns from the columns arg, aligned on the index arg, with values from values arg
}
\description{
Pivot the frame designated by the three columns: index, column, and value. Index and column should be
of type enum, int, or time.
For cases of multiple indexes for a column label, the aggregation method is to pick the first occurrence in the data frame
}
\examples{
\dontrun{
library(h2o)
h2o.init()

df = h2o.createFrame(rows = 1000, cols=3, factors=10, integer_fraction=1.0/3, 
                     categorical_fraction=1.0/3, missing_fraction=0.0, seed=123)
df$C3 = h2o.abs(df$C3)
h2o.pivot(df,index="C3",column="C2",value="C1")
}
}
