% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/frame.R
\name{as.matrix.H2OFrame}
\alias{as.matrix.H2OFrame}
\title{Convert an H2OFrame to a matrix}
\usage{
\method{as.matrix}{H2OFrame}(x, ...)
}
\arguments{
\item{x}{An H2OFrame object}

\item{...}{Further arguments to be passed down from other methods.}
}
\description{
Convert an H2OFrame to a matrix
}
\examples{
\donttest{
h2o.init()
irisPath <- system.file("extdata", "iris.csv", package="h2o")
iris <- h2o.uploadFile(path = irisPath)
iris.hex <- as.h2o(iris)
describe <- h2o.describe(iris.hex)
mins = as.matrix(apply(iris.hex, 2, min))
print(mins)
}
}

