% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{h2o.match}
\alias{\%in\%,H2OFrame,character-method}
\alias{\%in\%,H2OFrame,numeric-method}
\alias{h2o.match}
\alias{match,H2OFrame-method}
\title{Value Matching in H2O}
\usage{
h2o.match(x, table, nomatch = 0, incomparables = NULL)

\S4method{match}{H2OFrame}(x, table, nomatch = 0, incomparables = NULL)

\S4method{\%in\%}{H2OFrame,character}(x, table)

\S4method{\%in\%}{H2OFrame,numeric}(x, table)
}
\arguments{
\item{x}{a categorical vector from an \linkS4class{H2OFrame} object with
values to be matched.}

\item{table}{an R object to match \code{x} against.}

\item{nomatch}{the value to be returned in the case when no match is found.}

\item{incomparables}{a vector of calues that cannot be matched. Any value in
\code{x} matching a value in this vector is assigned the
\code{nomatch} value.}
}
\description{
\code{match} and \code{\%in\%} return values similar to the base R generic
functions.
}
\examples{
\donttest{
h2o.init()
hex <- as.h2o(iris)
match(hex[,5], c("setosa", "versicola"))   # versipepsi
}
}
\seealso{
\code{\link[base]{match}} for base R implementation.
}

