% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.partialPlot}
\alias{h2o.partialPlot}
\title{Partial Dependence Plots}
\usage{
h2o.partialPlot(object, data, cols, destination_key, nbins = 20,
  plot = TRUE)
}
\arguments{
\item{object}{An \linkS4class{H2OModel} object.}

\item{data}{An H2OFrame object used for scoring and constructing the plot.}

\item{cols}{Feature(s) for which partial dependence will be calculated.}

\item{destination_key}{An key reference to the created partial dependence tables in H2O.}

\item{nbins}{Number of bins used. For categorical columns make sure the number of bins exceed the level count.}

\item{plot}{A logical specifying whether to plot partial dependence table.}
}
\value{
Plot and list of calculated mean response tables for each feature requested.
}
\description{
Partial dependence plot gives a graphical depiction of the marginal effect of a variable on the response. The effect
of a variable is measured in change in the mean response. Note: Unlike randomForest's partialPlot when plotting
partial dependence the mean response (probabilities) is returned rather than the mean of the log class probability.
}
\examples{
\donttest{
library(h2o)
h2o.init(nthreads = -1)
prostate.path = system.file("extdata", "prostate.csv", package="h2o")
prostate.hex = h2o.uploadFile(path = prostate.path, destination_frame = "prostate.hex")
prostate.hex[, "CAPSULE"] <- as.factor(prostate.hex[, "CAPSULE"] )
prostate.hex[, "RACE"] <- as.factor(prostate.hex[,"RACE"] )
prostate.gbm = h2o.gbm(x = c("AGE","RACE"),
                       y = "CAPSULE",
                       training_frame = prostate.hex,
                       ntrees = 10,
                       max_depth = 5,
                       learn_rate = 0.1)
h2o.partialPlot(object = prostate.gbm, data = prostate.hex, cols = c("AGE", "RACE"))
}
}

