% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{apply,H2OFrame-method}
\alias{apply,H2OFrame-method}
\title{Apply on H2O Datasets}
\usage{
\S4method{apply}{H2OFrame}(X, MARGIN, FUN, ...)
}
\arguments{
\item{X}{an \linkS4class{H2OFrame} object on which \code{apply} will operate.}

\item{MARGIN}{the vector on which the function will be applied over, either
\code{1} for rows or \code{2} for columns.}

\item{FUN}{the function to be applied.}

\item{\dots}{optional arguments to \code{FUN}.}
}
\value{
Produces a new \linkS4class{H2OFrame} of the output of the applied
        function. The output is stored in H2O so that it can be used in
        subsequent H2O processes.
}
\description{
Method for apply on \linkS4class{H2OFrame} objects.
}
\examples{
\dontrun{
localH2O = h2o.init()
irisPath = system.file("extdata", "iris.csv", package="h2o")
iris.hex = h2o.importFile(localH2O, path = irisPath, destination_frame = "iris.hex")
summary(apply(iris.hex, 1, sum))
}
}
\seealso{
\link[base]{apply} for the base generic
}

