% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.setLevel}
\alias{h2o.setLevel}
\title{Set a Factor Column to a Level}
\usage{
h2o.setLevel(x, level)
}
\arguments{
\item{x}{a column from an \linkS4class{H2OFrame} object.}

\item{level}{The level at which the column will be set.}
}
\value{
An object of class \linkS4class{H2OFrame}.
}
\description{
A method to set a factor column to one of the levels.
}
\details{
Replace all other occurences with `level` in a factor column.
}
\examples{
localH2O <- h2o.init()
hex <- as.h2o(localH2O  , iris)
hex$Species <- h2o.setLevel(hex$Species, "versicolor")
}

