% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.gbm}
\alias{h2o.gbm}
\title{Gradient Boosted Machines}
\usage{
h2o.gbm(x, y, training_frame, model_id, distribution = c("AUTO", "gaussian",
  "bernoulli", "multinomial"), ntrees = 50, max_depth = 5, min_rows = 10,
  learn_rate = 0.1, nbins = 20, nbins_cats = 1024,
  validation_frame = NULL, balance_classes = FALSE,
  max_after_balance_size = 1, seed, nfolds, score_each_iteration, ...)
}
\arguments{
\item{x}{A vector containing the names or indices of the predictor variables to use in building the GBM model.}

\item{y}{The name or index of the response variable. If the data does not contain a header, this is the column index
number starting at 0, and increasing from left to right. (The response must be either an integer or a
categorical variable).}

\item{training_frame}{An \code{\linkS4class{H2OFrame}} object containing the variables in the model.}

\item{model_id}{(Optional) The unique id assigned to the resulting model. If
none is given, an id will automatically be generated.}

\item{distribution}{A \code{character} string. The loss function to be implemented.
Must be "AUTO", "bernoulli", "multinomial", or "gaussian"}

\item{ntrees}{A nonnegative integer that determines the number of trees to grow.}

\item{max_depth}{Maximum depth to grow the tree.}

\item{min_rows}{Minimum number of rows to assign to teminal nodes.}

\item{learn_rate}{An \code{interger} from \code{0.0} to \code{1.0}}

\item{nbins}{For numerical columns (real/int), build a histogram of this many bins, then split at the best point}

\item{nbins_cats}{For categorical columns (enum), build a histogram of this many bins, then split at the best point. Higher values can lead to more overfitting.}

\item{validation_frame}{An \code{\link{H2OFrame}} object indicating the validation dataset used to contruct the
confusion matrix. If left blank, this defaults to the training data when \code{nfolds = 0}}

\item{balance_classes}{logical, indicates whether or not to balance training data class
counts via over/under-sampling (for imbalanced data)}

\item{max_after_balance_size}{Maximum relative size of the training data after balancing class counts (can be less
than 1.0)}

\item{seed}{Seed for random numbers (affects sampling) - Note: only reproducible when running single threaded}

\item{nfolds}{(Optional) Number of folds for cross-validation. If \code{nfolds >= 2}, then \code{validation} must remain empty. **Currently not supported**}

\item{score_each_iteration}{Attempts to score each tree.}

\item{...}{extra arguments to pass on (currently no implemented)}
}
\description{
Builds gradient boosted classification trees, and gradient boosted regression trees on a parsed data set.
}
\details{
The default distribution function will guess the model type
based on the response column typerun properly the response column must be an numeric for "gaussian" or an
enum for "bernoulli" or "multinomial".
}
\examples{
library(h2o)
localH2O = h2o.init()

# Run regression GBM on australia.hex data
ausPath <- system.file("extdata", "australia.csv", package="h2o")
australia.hex <- h2o.uploadFile(localH2O, path = ausPath)
independent <- c("premax", "salmax","minairtemp", "maxairtemp", "maxsst",
                 "maxsoilmoist", "Max_czcs")
dependent <- "runoffnew"
h2o.gbm(y = dependent, x = independent, training_frame = australia.hex,
        ntrees = 3, max_depth = 3, min_rows = 2)
}
\seealso{
\code{\link{predict.H2OModel}} for prediction.
}

