% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{setupThresholds}
\alias{setupThresholds}
\title{Set up thresholds for ordinal indicators}
\usage{
setupThresholds(model)
}
\arguments{
\item{model}{A fully specified \link[OpenMx:MxModel-class]{MxModel} object that can be fit to each SNP.}
}
\value{
The given \link[OpenMx:MxModel-class]{MxModel} with appropriate thresholds added.
}
\description{
Ordinal indicator thresholds are freely estimated with fixed means
and variance. This function adds thresholds to the given
\code{model}.  If no indicators are ordinal, the given \code{model}
is returned without changes.
}
\details{
Thresholds are added using \link[OpenMx]{mxThreshold}. Starting
values for thresholds use the defaults provided by this function
which assumes a mean of zero and variance of the square root of
two.  This variance is appropriate for \link{buildOneFac} where the
implied model variance of ordinal indicators is one plus the square
of the factor loading, and the loading's starting value is 1.0.

You generally do not need to call this function directly because it
is already called by \link{buildOneFac} and similar. This
function is provided for advanced users who wish to write their own
model building functions.
}
\examples{
pheno <- data.frame(anxiety=cut(rnorm(500), c(-Inf, -.5, .5, Inf),
                    ordered_result = TRUE))
m1 <- buildOneItem(pheno, 'anxiety')
m1 <- setupThresholds(m1)
m1$Thresholds
}
