% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_joins.R
\name{lstjoin}
\alias{lstjoin}
\alias{lst_left_join}
\alias{lst_right_join}
\alias{lst_inner_join}
\alias{plst_left_join}
\alias{plst_right_join}
\alias{plst_inner_join}
\title{Joins for lists.}
\usage{
lst_left_join(lst_x, lst_y)

lst_right_join(lst_x, lst_y)

lst_inner_join(lst_x, lst_y)

plst_left_join(list_of_lsts)

plst_right_join(list_of_lsts)

plst_inner_join(list_of_lsts)
}
\arguments{
\item{lst_x, lst_y}{lists.}

\item{list_of_lsts}{A list of lists to be joined together.}
}
\value{
A list.
}
\description{
These functions join lists by matching elements by name. In the case of
\code{lst_left_join} \code{lst_x} is used as reference for traversal and its
names are looked for in \code{lst_y} for joining. In the case of
\code{lst_left_join}, \code{lst_y} is used as reference.
\code{lst_inner_join} only uses names common to both \code{lst_x} and
\code{lst_y} for combining elements.
}
\details{
The functions \code{plst_left_join}, \code{plst_right_join} and
\code{plst_inner_join} are parallel versions that allow joining more than two
lists easily, i.e., just pass a list of lists to be joined.
}
\keyword{internal}
