% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_metadata.R
\name{get_metadata}
\alias{get_metadata}
\title{Get GWAS Catalog metadata}
\usage{
get_metadata(verbose = FALSE, warnings = TRUE)
}
\arguments{
\item{verbose}{Whether to be chatty.}

\item{warnings}{Whether to trigger a warning if the request is not successful.}
}
\value{
A named \code{\link[base]{list}} whose \code{\link[base]{names}} are:
\itemize{
\item \code{ensembl_release_number}: \href{https://www.ensembl.org/info/docs/api/versions.html}{Ensembl release number};
\item \code{genome_build_version}: \href{https://www.ncbi.nlm.nih.gov/grc/human}{Genome build version};
\item \code{dbsnp_version}: \href{https://www.ncbi.nlm.nih.gov/projects/SNP/snp_summary.cgi}{dbSNP version}.
\item \code{usage_start_date}: Date since this combination of resource versions has been in use.
}
}
\description{
Provides a list of the resources the GWAS Catalog data is currently mapped
against: \href{https://www.ensembl.org/info/docs/api/versions.html}{Ensembl
release number}, \href{https://www.ncbi.nlm.nih.gov/grc/human}{Genome build
version} and
\href{https://www.ncbi.nlm.nih.gov/projects/SNP/snp_summary.cgi}{dbSNP
version}.In addition, the date since this combination of resource versions
has been in use is also returned.
}
\examples{
get_metadata(warnings = FALSE)
}
