% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{gutenberg_authors}
\alias{gutenberg_authors}
\title{Metadata about Project Gutenberg authors}
\format{A tbl_df with one row for each author, with the columns
\describe{
  \item{gutenberg_author_id}{Unique identifier for the author that can
  be used to join with the \link{gutenberg_metadata} dataset}
  \item{author}{The \code{agent_name} field from the original metadata}
  \item{alias}{Alias}
  \item{birthdate}{Year of birth}
  \item{deathdate}{Year of death}
  \item{wikipedia}{Link to Wikipedia article on the author. If there
  are multiple, they are "/"-delimited}
  \item{aliases}{List column of character vectors of aliases. If there
  are multiple, they are "/"-delimited}
}}
\usage{
gutenberg_authors
}
\description{
Data frame with metadata about each author of a Project
Gutenberg work. For space only metadata from people that have
been the single author of a work (not multiple authors,
contributors, etc) are included.
}
\seealso{
\link{gutenberg_metadata}, \link{gutenberg_subjects}
}
\keyword{datasets}

