% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guf.R
\name{round_something}
\alias{round_something}
\title{The function round_something() does numerical rounding with a specified number of decimals. The 'something' will typically be a data.frame with mixed column types, of which the numerical columns must be rounded. This function makes that easier: all non-numerical columns are left in place, the numerical columns are rounded. Columns that are character but can be interpreted as numerical are first converted to numerical, and then rounded.}
\usage{
round_something(something, decimals = 0)
}
\arguments{
\item{something}{The object of which the numbers need to be rounded. Can be a numerical or character vector, a matrix, a data.frame or a list containing these elements.}

\item{decimals}{An integer specifying how many decimal points the result must contain.}
}
\value{
The same structure as used for the input of 'something', but then with rounded numbers (where applicable).
}
\description{
The function round_something() does numerical rounding with a specified number of decimals. The 'something' will typically be a data.frame with mixed column types, of which the numerical columns must be rounded. This function makes that easier: all non-numerical columns are left in place, the numerical columns are rounded. Columns that are character but can be interpreted as numerical are first converted to numerical, and then rounded.
}
\examples{
my_DF = data.frame(A=c(1.111,2.22,3.3,4), B=c("A", "Bb", "Ccc", "Dddd"), row.names=c(1,2,3,4))
round_something(my_DF)
round_something(my_DF, 2)
my_list = list(A=c(1.111,2.22,3.3,4), B=c("A", "Bb", "Ccc", "Dddd"))
round_something(my_list)
round_something(my_list, 2)
}
