% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_global_p.R
\name{add_global_p}
\alias{add_global_p}
\alias{add_global_p.tbl_regression}
\alias{add_global_p.tbl_uvregression}
\title{Add the global p-values}
\usage{
add_global_p(x, ...)

\method{add_global_p}{tbl_regression}(
  x,
  include = everything(),
  keep = FALSE,
  anova_fun = global_pvalue_fun,
  type = "III",
  quiet,
  ...
)

\method{add_global_p}{tbl_uvregression}(
  x,
  include = everything(),
  keep = FALSE,
  anova_fun = global_pvalue_fun,
  type = "III",
  quiet,
  ...
)
}
\arguments{
\item{x}{(\code{tbl_regression}, \code{tbl_uvregression})\cr
Object with class \code{'tbl_regression'} or \code{'tbl_uvregression'}}

\item{...}{Additional arguments to be passed to \code{car::Anova},
\code{aod::wald.test()} or \code{anova_fun} (if specified)}

\item{include}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to calculate global p-value for. Default is \code{everything()}}

\item{keep}{(scalar \code{logical})\cr
Logical argument indicating whether to also retain the individual
p-values in the table output for each level of the categorical variable.
Default is \code{FALSE}.}

\item{anova_fun}{(\code{function})\cr
Function used to calculate global p-values.
Default is generic \code{\link[=global_pvalue_fun]{global_pvalue_fun()}}, which wraps \code{car::Anova()} for
most models. The \code{type} argument is passed to this function. See help file for details.

To pass a custom function, it must accept as its first argument is a model.
Note that anything passed in \code{...} will be passed to this function.
The function must return an object of class \code{'cards'} (see \code{cardx::ard_car_anova()} as an example),
or a tibble with columns \code{'term'} and \code{'p.value'} (e.g. \verb{\\(x, type, ...) car::Anova(x, type, ...) |> broom::tidy()}).}

\item{type}{Type argument passed to \code{anova_fun}. Default is \code{"III"}}

\item{quiet}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\description{
This function uses \code{car::Anova()} (by default) to calculate global p-values
for model covariates.
Output from \code{tbl_regression} and \code{tbl_uvregression} objects supported.
}
\examples{
\dontshow{if (gtsummary:::is_pkg_installed(c("cardx", "broom", "car"), reference_pkg = "gtsummary")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Example 1 ----------------------------------
lm(marker ~ age + grade, trial) |>
  tbl_regression() |>
  add_global_p()

# Example 2 ----------------------------------
trial[c("response", "age", "trt", "grade")] |>
  tbl_uvregression(
    method = glm,
    y = response,
    method.args = list(family = binomial),
    exponentiate = TRUE
  ) |>
  add_global_p()
\dontshow{\}) # examplesIf}
}
\author{
Daniel D. Sjoberg
}
