% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtfs2gps.R
\name{gtfs2gps}
\alias{gtfs2gps}
\title{Convert GTFS to GPS-like data given a spatial resolution}
\usage{
gtfs2gps(
  gtfs_data,
  spatial_resolution = 50,
  parallel = FALSE,
  strategy = NULL,
  filepath = NULL,
  compress = FALSE,
  continue = FALSE
)
}
\arguments{
\item{gtfs_data}{A path to a GTFS file to be converted to GPS, or a GTFS data
represented as a list of data.tables.}

\item{spatial_resolution}{The spatial resolution in meters. Default is 50m.}

\item{parallel}{Decides whether the function should run in parallel. Defaults is FALSE.
When TRUE, it will use all cores available minus one using future::plan() with
strategy "multiprocess" internally.
Note that it is possible to create your own plan before calling gtfs2gps().
In this case, do not use this argument.}

\item{strategy}{This argument is deprecated. Please use argument plan instead or
use future::plan() directly.}

\item{filepath}{Output file path. As default, the output is returned when gtfs2gps finishes.
When this argument is set, each route is saved into a txt file within filepath,
with the name equals to its id. In this case, no output is returned. See argument
compress for another option.}

\item{compress}{Argument that can be used only with filepath. When TRUE, it
compresses the output files by saving them using rds format. Default value is FALSE.
Note that compress guarantees that the data saved will be read in the same way as it
was created in R. If not compress, the txt extension requires the data to be converted
from ITime to string, and therefore they need to manually converted back to ITime to 
be properly handled by gtfs2gps.}

\item{continue}{Argument that can be used only with filepath. When TRUE, it
skips processing the shape identifiers that were already saved into files.
It is useful to continue processing a GTFS file that was stopped for some
reason. Default value is FALSE.}
}
\value{
A data.table, where each row represents a GPS point. The following columns are
returned (units of measurement in parenthesis): dist and cumdist (meters), cumtime (seconds),
shape_pt_lon and shape_pt_lat (degrees), speed (km/h), departure_time (hh:mm:ss), .
}
\description{
Convert GTFS data to GPS format by sampling points using a
spatial resolution. This function creates additional points in order to
guarantee that two points in a same trip will have at most a given
distance, indicated as a spatial resolution. It is possible to use future package
to parallelize the execution (or use argument plan). This function also
uses progressr internally to show progress bars.
}
\examples{
library(dplyr)
poa <- read_gtfs(system.file("extdata/poa.zip", package = "gtfs2gps"))
subset <- filter_by_shape_id(poa, "T2-1") \%>\%
  filter_single_trip()

poa_gps <- gtfs2gps(subset)
}
