% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_single_nucleus_gex_summary.R
\name{get_single_nucleus_gex_summary}
\alias{get_single_nucleus_gex_summary}
\title{Get Single Nucleus Gex Summary}
\usage{
get_single_nucleus_gex_summary(
  datasetId = "gtex_snrnaseq_pilot",
  tissueSiteDetailIds = NULL,
  page = 0,
  itemsPerPage = getOption("gtexr.itemsPerPage"),
  .verbose = getOption("gtexr.verbose"),
  .return_raw = FALSE
)
}
\arguments{
\item{datasetId}{String. Unique identifier of a dataset. Usually includes a
data source and data release. Options: "gtex_v8", "gtex_snrnaseq_pilot".}

\item{tissueSiteDetailIds}{Character vector of IDs for tissues of interest.
Can be GTEx specific IDs (e.g. "Whole_Blood"; use
\code{\link[=get_tissue_site_detail]{get_tissue_site_detail()}} to see valid values) or Ontology IDs.}

\item{page}{Integer (default = 0).}

\item{itemsPerPage}{Integer (default = 250). Set globally to maximum value
100000 with \code{options(list(gtexr.itemsPerPage = 100000))}.}

\item{.verbose}{Logical. If \code{TRUE} (default), print paging information. Set
to \code{FALSE} globally with \code{options(list(gtexr.verbose = FALSE))}.}

\item{.return_raw}{Logical. If \code{TRUE}, return the raw API JSON response.
Default = \code{FALSE}}
}
\value{
A tibble. Or a list if \code{.return_raw = TRUE}.
}
\description{
Retrieve Summarized Single Nucleus Gene Expression Data.

\href{https://gtexportal.org/api/v2/redoc#tag/Expression-Data-Endpoints/operation/get_single_nucleus_gex_summary_api_v2_expression_singleNucleusGeneExpressionSummary_get}{GTEx Portal API documentation}
}
\examples{
\dontrun{
# all tissues
get_single_nucleus_gex_summary()

# filter for specific tissue
get_single_nucleus_gex_summary(tissueSiteDetailIds = c(
  "Breast_Mammary_Tissue",
  "Skin_Sun_Exposed_Lower_leg"
))
}
}
\seealso{
Other Expression Data Endpoints: 
\code{\link{get_clustered_median_exon_expression}()},
\code{\link{get_clustered_median_gene_expression}()},
\code{\link{get_clustered_median_junction_expression}()},
\code{\link{get_clustered_median_transcript_expression}()},
\code{\link{get_expression_pca}()},
\code{\link{get_gene_expression}()},
\code{\link{get_median_exon_expression}()},
\code{\link{get_median_gene_expression}()},
\code{\link{get_median_junction_expression}()},
\code{\link{get_median_transcript_expression}()},
\code{\link{get_single_nucleus_gex}()},
\code{\link{get_top_expressed_genes}()}
}
\concept{Expression Data Endpoints}
