% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_neighbor_gene.R
\name{get_neighbor_gene}
\alias{get_neighbor_gene}
\title{Get Neighbor Gene}
\usage{
get_neighbor_gene(pos, chromosome, bp_window, page = 0, itemsPerPage = 250)
}
\arguments{
\item{pos}{Integer, vector.}

\item{chromosome}{String. One of "chr1", "chr2", "chr3", "chr4", "chr5",
"chr6", "chr7", "chr8", "chr9", "chr10", "chr11", "chr12", "chr13",
"chr14", "chr15", "chr16", "chr17", "chr18", "chr19", "chr20", "chr21",
"chr22", "chrM", "chrX", "chrY".}

\item{bp_window}{Integer.}

\item{page}{Integer (default = 0).}

\item{itemsPerPage}{Integer (default = 250).}
}
\value{
A tibble.
}
\description{
Find all neighboring genes on a certain chromosome around a
position with a certain window size.

\href{https://gtexportal.org/api/v2/redoc#tag/Reference-Genome-Endpoints/operation/get_neighbor_gene_api_v2_reference_neighborGene_get}{GTEx API Portal documentation}
}
\examples{
\dontrun{
get_neighbor_gene(pos = 1000000, chromosome = "chr1", bp_window = 10000)
}
}
\seealso{
Other Reference Genome Endpoints: 
\code{\link{get_exons}()},
\code{\link{get_gene_search}()},
\code{\link{get_genes}()},
\code{\link{get_genomic_features}()},
\code{\link{get_gwas_catalog_by_location}()},
\code{\link{get_transcripts}()}
}
\concept{Reference Genome Endpoints}
