% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grow_gompertz.R
\name{grow_gompertz}
\alias{grow_gompertz}
\title{Growth Model According to Gompertz}
\usage{
grow_gompertz(time, parms)
}
\arguments{
\item{time}{vector of time steps (independent variable).}

\item{parms}{named parameter vector of the Gompertz growth model with:
\itemize{
  \item \code{y0} initial value of abundance,
  \item \code{mumax} maximum growth rate (1/time),
  \item \code{K} maximum abundance (carrying capacity).

}}
}
\value{
vector of dependent variable (\code{y})
}
\description{
Gompertz growth model written as analytical solution of the differential
  equation system.
}
\details{
The equation used here is:
\deqn{y = K * exp(log(y0 / K) * exp(-mumax * time))}
}
\examples{

time <- seq(0, 30, length=200)
y    <- grow_gompertz(time, c(y0=1, mumax=.2, K=10))[,"y"]
plot(time, y, type="l", ylim=c(0, 20))


}
\references{
Tsoularis, A. (2001) Analysis of Logistic Growth Models.
  Res. Lett. Inf. Math. Sci, (2001) 2, 23-46.
}
\seealso{
Other growth models: \code{\link{grow_baranyi}},
  \code{\link{grow_exponential}}, \code{\link{grow_huang}},
  \code{\link{grow_logistic}}, \code{\link{grow_richards}},
  \code{\link{growthmodel}}, \code{\link{ode_genlogistic}},
  \code{\link{ode_twostep}}
}

