% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_factor.R
\name{group_factor}
\alias{group_factor}
\title{Create grouping factor for subsetting your data.}
\usage{
group_factor(data, n, method = "n_dist", force_equal = FALSE,
  allow_zero = FALSE, descending = FALSE, randomize = FALSE)
}
\arguments{
\item{data}{Dataframe or Vector}

\item{n}{Number of groups, group size, or step size
(depending on chosen method)
Given as whole numbers or percentage (\code{0} < n < \code{1}).}

\item{method}{\code{greedy, n_dist, n_fill, n_last, n_rand, or staircase}

 \code{greedy} divides up the data greedily given a specified group size
 \eqn{(e.g. 10, 10, 10, 10, 10, 7)}

 \code{n_dist} divides the data into a specified number of groups and
 distributes excess data points across groups
 \eqn{(e.g. 11, 11, 12, 11, 12)}

 \code{n_fill} divides the data into a specified number of groups and
 fills up groups with excess data points from the beginning
 \eqn{(e.g. 12, 12, 11, 11, 11)}

 \code{n_last} divides the data into a specified number of groups.
 The algorithm finds the most equal group sizes possible,
 using all data points. Only the last group is able to differ in size
 \eqn{(e.g. 11, 11, 11, 11, 13)}

 \code{n_rand} divides the data into a specified number of groups.
 Excess data points are placed randomly in groups (only 1 per group)
 \eqn{(e.g. 12, 11, 11, 11, 12)}

 \code{staircase} uses step_size to divide up the data.
 Group size increases with 1 step for every group,
 until there is no more data
 \eqn{(e.g. 5, 10, 15, 20, 7)}}

\item{force_equal}{Create equal groups by discarding excess data points.
Implementation varies between methods. (Logical)}

\item{allow_zero}{Whether n can be passed as \code{0}. (Logical)}

\item{descending}{Change direction of method. (Not fully implemented)
(Logical)}

\item{randomize}{Randomize the grouping factor (Logical)}
}
\value{
Grouping factor with 1s for group 1, 2s for group 2, etc.
}
\description{
Divides data into groups by a range of methods.
 Creates and returns a grouping factor
 with 1s for group 1, 2s for group 2, etc.
}
\examples{
# Attach packages
library(groupdata2)
library(dplyr)

# Create a dataframe
df <- data.frame("x"=c(1:12),
 "species" = rep(c('cat','pig', 'human'), 4),
 "age" = sample(c(1:100), 12))

# Using group_factor()
groups <- group_factor(df, 5, method = 'n_dist')
df$groups <- groups

}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\seealso{
Other grouping functions: \code{\link{group}},
  \code{\link{splt}}

Other staircase tools: \code{\link{\%staircase\%}}
}

