% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_measure.R
\name{pivot_measure}
\alias{pivot_measure}
\alias{pivot_measure.otgrid}
\alias{pivot_measure.data.frame}
\title{Pivot Measure}
\usage{
pivot_measure(x, ...)

\method{pivot_measure}{otgrid}(
  x,
  y,
  p.1 = 2,
  p.2 = p.1,
  max.it = 100,
  tol = 1e-04,
  threads = 1,
  start.pivot = c("independent", "northwestcorner"),
  dual.method = c("discrete", "epsilon-discrete", "epsilon-histogram"),
  dual.params = list(),
  return.it = FALSE,
  ...
)

\method{pivot_measure}{data.frame}(x, a, b, p.1 = 2, p.2 = p.1, ...)
}
\arguments{
\item{x}{an object of class \code{"otgrid"} the mass is to be transported from or
a data frame with columns \code{from}, \code{to} and \code{mass} specifying the optimal transport plan.}

\item{...}{further arguments (currently unused).}

\item{y}{an object of class \code{"otgrid"} the mass is to be transported to.}

\item{p.1}{the first power \eqn{\geq 1} of the cost.}

\item{p.2}{the second power \eqn{\geq 1} of the cost.}

\item{max.it}{the maximum number of iterations.}

\item{tol}{the desired accuracy.}

\item{threads}{number of threads to use.}

\item{start.pivot}{the start pivot to use: matrix representing an actual coupling or \code{"independent"} or \code{"northwestcorner"}.}

\item{dual.method}{the name of the dual calculators to use: \code{"discrete"}, \code{"epsilon-discrete"} or \code{"epsilon-histogram"}.}

\item{dual.params}{list of parameters for the dual calculators.}

\item{return.it}{logical value specifying whether or not the costs and dual gaps in each iteration are to be returned .}

\item{a}{an object of class \code{"otgrid"} the mass is to be transported from.}

\item{b}{an object of class \code{"otgrid"} the mass is to be transported to.}
}
\value{
an object of class \code{"otgridtransport"} that contains the following elements:
\tabular{ll}{
\code{from}  \tab an object of class \code{"otgrid"} the mass is transported from. \cr
\code{to}    \tab an object of class \code{"otgrid"} the mass is transported to. \cr
\code{p.1}   \tab the first power \eqn{\geq 1} of the cost function. \cr
\code{p.2}   \tab the second power \eqn{\geq 1} of the cost function. \cr
\code{pivot} \tab a matrix representing the pivot measure.
}
If the Frank-Wolfe algorithm is used to approximate the pivot measure, the element \code{conv} indicates whether or not
we can ensured that the error is less or equal to the given precision \code{tol}.

If \code{return.it = TRUE}, then it also contains the vectors \code{costs} and \code{dualgaps} of costs and dual gaps in each iteration.

Also note that the functions \code{print} and \code{plot} are available for objects of class \code{"otgridtransport"}.
}
\description{
Calculate the pivot measure of the optimal transport between two-dimensional grids.
}
\details{
Denote with \eqn{X_1 \times X_2} and \eqn{Y_1 \times Y_2} the two-dimensional grids that \code{x} and \code{y} lie on, respectively.
The pivot measure is a measure on \eqn{Y_1 \times X_2} that specifies the whole transport between \code{x} and \code{y} given that the cost
is of the separable form \eqn{c(x, y) = | x_1 - y_1 |^{p_1} + | x_2 - y_2 |^{p_2}}.

The pivot measure is approximated using the Frank-Wolfe algorithm. The algorithm starts with an initial guess (\code{start.pivot}), e.g., the
independent coupling (\code{"independent"}) or the north-west-corner rule (\code{"northwestcorner"}). Then, in each iteration step, the dual solutions of
multiple one-dimensional transport problems are calculated and combined to give the gradient. To ensure differentiability, the dual solutions
must be unique. There are three different calculators for the dual solutions, of which the last two ensure uniqueness:
\tabular{lll}{
name                  \tab description \tab \code{dual.params} \cr
\code{"discrete"}          \tab the distributions are basically unchanged, due to rounding errors the support points
are moved by a small positive amount.  \tab \code{right.margin = 1e-15} \cr
\code{"epsilon-discrete"}  \tab additionally, the support is made connected by uniformly adding \eqn{\varepsilon}
mass. \tab + \code{eps = 1e-8} \cr
\code{"epsilon-histogram"} \tab additionally, each point mass is distributed uniformly in a bin around said point \tab + \code{width = 1e-8}
}

A pivot measure can also be computed from an optimal transport plan.

Finally, the pivot measure can be used to calculate the full transport plan and cost.
}
\examples{
x <- otgrid(rbind(c(0, 0, 0, 0, 0, 0, 0, 0, 0),
                 c(0, 0, 1, 0, 0, 0, 0, 0, 0),
                 c(0, 1, 2, 1, 0, 0, 0, 0, 0),
                 c(0, 0, 1, 0, 0, 0, 0, 0, 0), 
                  0, 0, 0, 0, 0))
y <- otgrid(rbind(0, 0, 0, 0,
                 c(0, 0, 0, 0, 0, 0, 0, 0, 0),
                 c(0, 0, 0, 0, 0, 0, 1, 0, 0),
                 c(0, 0, 0, 0, 0, 1, 2, 1, 0),
                 c(0, 0, 0, 0, 0, 0, 1, 0, 0), 0))

pm <- pivot_measure(x, y, p.1 = 1, p.2 = 2, dual.method = "epsilon-discrete")

print(pm)
plot(pm)

# use pivot measure to calculate cost and plan
pm <- transport_cost(pm)
pm <- transport_df(pm)
print(pm)

# calculate pivot from plan
pm2 <- pivot_measure(pm$df, x, y)
plot(pm2)
}
\seealso{
transport plan \code{\link{transport_df}}, transport cost \code{\link{transport_cost}}, two-dimensional grid \code{\link{otgrid}},
plot \code{\link{plot.otgridtransport}}
}
