% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_greta_deps.R
\name{install_greta_deps}
\alias{install_greta_deps}
\title{Install Python dependencies for greta}
\usage{
install_greta_deps(
  method = c("auto", "virtualenv", "conda"),
  conda = "auto",
  timeout = 5,
  ...
)
}
\arguments{
\item{method}{Installation method ("virtualenv" or "conda")}

\item{conda}{The path to a \code{conda} executable. Use \code{"auto"} to allow
\code{reticulate} to automatically find an appropriate \code{conda} binary. See
\strong{Finding Conda} for more details.}

\item{timeout}{maximum time in minutes until the installation for each
installation component times out and exits. Default is 5 minutes per
installation component.}

\item{...}{Optional arguments, reserved for future expansion.}
}
\description{
This is a helper function to install Python dependencies needed. This
includes Tensorflow version 1.14.0, Tensorflow Probability 0.7.0, and
numpy version 1.16.4. These Python modules will be installed into a
virtual or conda environment, named "greta-env". Note that "virtualenv" is
not available on Windows.
}
\note{
This will automatically install Miniconda (a minimal version of the
Anaconda scientific software management system), create a 'conda'
environment for greta named 'greta-env' with required python and python
package versions, and forcibly switch over to using that conda environment.

If you don't want to use conda or the "greta-env" conda environment, you
can install these specific versions of tensorflow (version 1.14.0), and
tensorflow-probability (version 0.7.0), and ensure that the python
environment that is initialised in this R session has these versions
installed. This is now always straightforward, so we recommend installing
the python packages using \code{install_greta_deps()} for most users.
}
\examples{
\dontrun{
install_greta_deps()
}
}
