% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms.R
\name{transforms}
\alias{transforms}
\alias{inverse-links}
\alias{iprobit}
\alias{ilogit}
\alias{icloglog}
\alias{icauchit}
\alias{log1pe}
\title{transformation functions for greta arrays}
\usage{
iprobit(x)

ilogit(x)

icloglog(x)

icauchit(x)

log1pe(x)
}
\arguments{
\item{x}{a real-valued (i.e. values ranging from -Inf to Inf) greta array to
transform to a constrained value}
}
\description{
transformations for greta arrays, which may also be used as
  inverse link functions. Also see \link{operators} and \link{functions}.
}
\details{
greta does not allow you to state the transformation/link on the
  left hand side of an assignment, as is common in the BUGS and STAN
  modelling languages. That's because the same syntax has a very different
  meaning in R, and can only be applied to objects that are already in
  existence. The inverse forms of the common link functions (prefixed with an
  'i') are therefore more likely to useful in modelling, and these are what
  are provided here.

  The \code{log1pe} inverse link function is equivalent to \code{log(1 + exp(x))},
  yielding a positive transformed parameter. Unlike the log transformation,
  this transformation is approximately linear for x > 1. i.e. when \eqn{x >
  1}, \eqn{y \approx x}
}
\examples{
\dontrun{

 x = normal(1, 3, dim = 10)

 # transformation to the unit interval
 p1 <- iprobit(x)
 p2 <- ilogit(x)
 p3 <- icloglog(x)
 p4 <- icauchit(x)

 # and to positive reals
 y <- log1pe(x)
}
}
