\name{accrualReport}
\alias{accrualReport}
\title{Accrual Report}
\usage{
accrualReport(formula, data = NULL, subset = NULL, na.action = na.retain,
  dateRange = NULL, zoom = NULL, targetN = NULL, targetDate = NULL,
  closeDate = NULL, enrollmax = NULL, minrand = 10, panel = "accrual",
  h = 2.5, w = 3.75, hb = 5, wb = 5, hdot = 3.5)
}
\arguments{
  \item{formula}{formula object, with time variables on the
  left (separated by +) and grouping variables on the
  right.  Enrollment date, randomization date, region,
  country, and site when present must have the variables in
  parenthesis preceeded by the key words \code{enrollment,
  randomize, region, country, site}.}

  \item{data}{data frame.}

  \item{subset}{a subsetting epression for the entire
  analysis.}

  \item{na.action}{a NA handling function for data frames,
  default is \code{na.retain}.}

  \item{dateRange}{\code{Date} or character 2-vector
  formatted as \code{yyyy-mm-dd}.  Provides the range on
  the \code{x}-axis (before any zooming).}

  \item{zoom}{\code{Date} or character 2-vector for an
  option zoomed-in look at accrual.}

  \item{targetN}{integer vector with target sample sizes
  over time, same length as \code{targetDate}}

  \item{targetDate}{\code{Date} or character vector
  corresponding to \code{targetN}}

  \item{closeDate}{\code{Date} or characterstring.  Used
  for randomizations per month and per site-month -
  contains the dataset closing date to be able to compute
  the number of dates that a group (country, site, etc.)
  has been online since randomizating its first subject.}

  \item{enrollmax}{numeric specifying the upper y-axis
  limit for cumulative enrollment when not zoomed}

  \item{minrand}{integer.  Minimum number of randomized
  subjects a country must have before a box plot of time to
  randomization is included.}

  \item{panel}{character string.  Name of panel, which goes
  into file base names and figure labels for
  cross-referencing.}

  \item{h}{numeric.  Height of ordinary plots, in inches.}

  \item{w}{numeric.  Width of ordinary plots.}

  \item{hb}{numeric.  Height of extended box plots.}

  \item{wb}{numeric.  Weight of extended box plots.}

  \item{hdot}{numeric.  Height of dot charts in inches.}
}
\description{
Generate graphics and LaTeX to analyze subject accrual
}
\details{
Typically the left-hand-side variables of the formula, in
order, are date of enrollment and date of randomization,
with subjects enrolled but not randomized having missing
date of randomization.  Given such date variables, this
function generates cumulative frequencies optionally with
target enrollment/randomization numbers and with
time-zooming.  Makes a variety of dot charts by
right-hand-side variables: number of subjects, number of
sites, number of subjects per site, fraction of enrolled
subjects randomized, number per month, number per
site-month.
}
\examples{
\dontrun{
# See test.Rnw in tests directory
}
}

