% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_gran.R
\name{validate_gran}
\alias{validate_gran}
\title{Validate created granularities with existing columns}
\usage{
validate_gran(.data, gran = NULL, hierarchy_tbl = NULL,
  validate_col = NULL, ...)
}
\arguments{
\item{.data}{A tsibble object.}

\item{gran}{the granularity to be created for validation.}

\item{hierarchy_tbl}{A hierarchy table}

\item{validate_col}{A column in the data which acts as validator}

\item{...}{Other arguments passed on to individual methods.}
}
\value{
A tsibble with an additional column of granularity
}
\description{
Validate created granularities with existing columns
}
\examples{
library(dplyr)
library(tsibble)
cricket_tsibble <- cricket \%>\%
  mutate(data_index = row_number()) \%>\%
  as_tsibble(index = data_index)

hierarchy_model <- tibble::tibble(
  units = c("index", "ball", "over", "inning", "match"),
  convert_fct = c(1, 6, 20, 2, 1)
)
cricket_tsibble \%>\% validate_gran(
  gran = "over_inning",
  hierarchy_tbl = hierarchy_model,
  validate_col = "over"
)
}
