% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evenly.R
\name{ref_level}
\alias{ref_level}
\alias{level}
\title{Return the reference or specific level of a factor}
\usage{
ref_level(fct)

level(fct, level)
}
\arguments{
\item{fct}{factor; the factor from which the reference or specific level will
be extracted.}

\item{level}{character; the specific level to extract in the case of
\code{level()}.}
}
\value{
A length 1 factor with the same levels as the supplied factor \code{fct}.
}
\description{
Extracts the reference or a specific level the supplied factor,
returning it as a factor with the same levels as the one supplied.
}
\examples{
\dontshow{set.seed(1)}
f <- factor(sample(letters[1:5], 100, replace = TRUE))

# the reference level
ref_level(f)

# a specific level
level(f, level = "b")

# note that the levels will always match the input factor
identical(levels(f), levels(ref_level(f)))
identical(levels(f), levels(level(f, "c")))
}
