% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior-samples.R
\name{fitted_samples}
\alias{fitted_samples}
\alias{fitted_samples.gam}
\alias{predicted_samples}
\alias{predicted_samples.gam}
\title{Draw fitted values from the posterior distribution}
\usage{
fitted_samples(model, ...)

\method{fitted_samples}{gam}(
  model,
  n = 1,
  newdata,
  seed,
  scale = c("response", "linear_predictor"),
  freq = FALSE,
  unconditional = FALSE,
  ncores = 1L,
  ...
)

predicted_samples(model, ...)

\method{predicted_samples}{gam}(
  model,
  n = 1,
  newdata = NULL,
  seed = NULL,
  freq = FALSE,
  unconditional = FALSE,
  weights = NULL,
  ...
)
}
\arguments{
\item{model}{a fitted model of the supported types}

\item{...}{arguments passed to other methods. For \code{fitted_samples()}, these
are passed on to \code{predict.gam()}.}

\item{n}{numeric; the number of posterior samples to return.}

\item{newdata}{data frame; new observations at which the posterior draws
from the model should be evaluated. If not supplied, the data used to fit
the model will be used for \code{newdata}, if available in \code{model}.}

\item{seed}{numeric; a random seed for the simulations.}

\item{scale}{character;}

\item{freq}{logical; \code{TRUE} to return the frequentist covariance matrix of
the parameter estimators, \code{FALSE} to return the Bayesian posterior
covariance matrix of the parameters.}

\item{unconditional}{logical; if \code{TRUE} (and \code{freq == FALSE}) then the
Bayesian smoothing parameter uncertainty corrected covariance matrix is
returned, if available.}

\item{ncores}{number of cores for generating random variables from a
multivariate normal distribution. Passed to \code{\link[mvnfast:rmvn]{mvnfast::rmvn()}}.
Parallelization will take place only if OpenMP is supported (but appears
to work on Windows with current \code{R}).}

\item{weights}{numeric; a vector of prior weights. If \code{newdata} is null
then defaults to \code{object[["prior.weights"]]}, otherwise a vector of ones.}
}
\value{
A tibble (data frame) with 3 columns containing the posterior
predicted values in long format. The columns are
\itemize{
\item \code{row} (integet) the row of \code{newdata} that each posterior draw relates to,
\item \code{draw} (integer) an index, in range \code{1:n}, indicating which draw each row
relates to,
\item \code{response} (numeric) the predicted response for the indicated row of
\code{newdata}.
}

A tibble (data frame) with 3 columns containing the posterior
predicted values in long format. The columns are
\itemize{
\item \code{row} (integet) the row of \code{newdata} that each posterior draw relates to,
\item \code{draw} (integer) an index, in range \code{1:n}, indicating which draw each row
relates to,
\item \code{response} (numeric) the predicted response for the indicated row of
\code{newdata}.
}
}
\description{
Expectations (fitted values) of the response drawn from the posterior
distribution of fitted model, created via \code{simulate()} (e.g.
\code{\link[=simulate.gam]{simulate.gam()}}) and returned in a tidy, long, format.

Predicted values of the response drawn from the posterior distribution of
fitted model, created via \code{simulate()} (e.g. \code{\link[=simulate.gam]{simulate.gam()}})
and returned in a tidy, long, format.
}
\examples{
load_mgcv()
\dontshow{
set.seed(2)
op <- options(cli.unicode = FALSE)
}
dat <- gamSim(1, n = 1000, dist = "normal", scale = 2)
m1 <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat, method = "REML")

fitted_samples(m1, n = 5, seed = 42)
\dontshow{options(op)}
load_mgcv()
\dontshow{
set.seed(2)
op <- options(cli.unicode = FALSE)
}
dat <- gamSim(1, n = 1000, dist = "normal", scale = 2)
m1 <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat, method = "REML")

predicted_samples(m1, n = 5, seed = 42)
\dontshow{options(op)}
}
\author{
Gavin L. Simpson

Gavin L. Simpson
}
