% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotDendrogram}
\alias{plotDendrogram}
\title{Plot dendrogram to visualize the clustering obtained by the hierarchical
clustering algorithm}
\usage{
plotDendrogram(res, labels = NULL, labcex = 0.5)
}
\arguments{
\item{res}{output of graphClustering()}

\item{labels}{network labels, default (NULL) network number.}

\item{labcex}{size of labels in the figure}
}
\value{
dendrogram
}
\description{
Plot dendrogram to visualize the clustering obtained by the hierarchical
clustering algorithm
}
\examples{
theta <- list(pi=c(.5,.5), gamma=matrix((1:4)/8,2,2))
obs <- rCollectSBM(rep(10,4), theta)$listGraphs
res <- graphClustering(obs, nbCores=2)
plotDendrogram(res)
}
