% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNodes.R
\name{getNodes}
\alias{getNodes}
\title{getNodes}
\usage{
getNodes(edges, source = "source", target = "target", ...)
}
\arguments{
\item{edges}{data.frame of edges as typically returned by 
\code{\link{getEdges}}}

\item{source}{Column of source nodes in \code{edges}, must be a 
\code{character} string, defaults to \code{source}.}

\item{target}{Column of target nodes in \code{edges}, must be a 
\code{character} string, required.}

\item{...}{Any other columns to be passed on to the \code{source} nodes - 
will not be applied to \code{target} nodes.}
}
\description{
get nodes from a data.frame of edges as typically returned by 
\code{\link{getEdges}}
}
\details{
Duplicate values are dropped, additional arguments (\code{...}) are 
only applied to nodes from \code{source}.
}
\examples{
\dontrun{
# load twitteR
library(twitteR)

# authenticate
token <- setup_twitter_oauth(consumer_key, consumer_secret, 
                             access_token=NULL, access_secret=NULL)
                             
# search tweets
tweets <- searchTwitter("rstats", n = 200)

# unlist to data.frame
tweets <- twListToDF(tweets)

# get edges
edges <- getEdges(data = tweets, tweets = "text", source = "screenName")

# get nodes
nodes <- getNodes(edges)

# load igraph
library(igraph)

# plot
g <- graph.data.frame(edges, directed=TRUE, vertices = nodes)

plot(g)
}

}
\author{
John Coene \email{jcoenep@gmail.com}
}

