% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_PAF_continuous.R
\name{plot_continuous}
\alias{plot_continuous}
\title{Plot hazard ratios, odds ratios or risk ratios comparing differing values of a continuous exposure to a reference level}
\usage{
plot_continuous(
  model,
  riskfactor,
  data,
  S = 10,
  ref_val = NA,
  ci_level = 0.95,
  min_risk_q = 0.1,
  plot_region = TRUE,
  plot_density = TRUE,
  n_x = 10000,
  theylab = "OR",
  qlist = seq(from = 0.001, to = 0.999, by = 0.001),
  interact = FALSE
)
}
\arguments{
\item{model}{A fitted model (either glm, clogit or coxph)}

\item{riskfactor}{The string name of a continuous exposure or risk factor represented in the data and model}

\item{data}{Data frame used to fit the model}

\item{S}{Default 10.  The integer number of random samples used to calculate average differences in linear predictors. Only relevant to set when interact=TRUE}

\item{ref_val}{The reference value used in plotting.  If left at NA, the median value of the risk factor is used}

\item{ci_level}{Numeric.  A number between 0 and 1 specifying the confidence level}

\item{min_risk_q}{Default .1.  A number between 0 and 1 representing the desired risk quantile for the continuous risk factor}

\item{plot_region}{Default TRUE.  Logical specifying whether the targeted region corresponding to an intervention setting the continuous risk factor at a quantile min_risk_q or lower is to be plotted}

\item{plot_density}{Default TRUE.  Logical specifying whether density of distribution of risk factor is to be added to the plot}

\item{n_x}{Default 10000.  How many values of riskfactor will be used to plot spline (when interact=FALSE)}

\item{theylab}{Default "OR".  Y-axis label of the plot}

\item{qlist}{Vector of quantile values for q, corresponding to the plotted values of PAF_q for each risk factor/exposure}

\item{interact}{Default "FALSE".  Set to TRUE spline models enter as interactions.}
}
\value{
A ggplot2 plotting object
}
\description{
Plot hazard ratios, odds ratios or risk ratios comparing differing values of a continuous exposure to a reference level
}
\examples{
library(survival)
library(splines)
model_continuous <- glm(formula = case ~ region * ns(age, df = 5) +
 sex * ns(age, df = 5) + education +exercise + ns(diet, df = 3) +
 alcohol + stress + ns(lipids,df = 3) + ns(waist_hip_ratio, df = 3) +
  high_blood_pressure, family = "binomial", data = stroke_reduced)
plot_continuous(model_continuous,riskfactor="diet",data=stroke_reduced)
}
\references{
Ferguson, J., Maturo, F., Yusuf, S. and O’Donnell, M., 2020. Population attributable fractions for continuously distributed exposures. Epidemiologic Methods, 9(1)
}
