% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amino_acid_pairs.R
\name{amino_acid_pairs}
\alias{amino_acid_pairs}
\title{Generate amino acid pairs}
\usage{
amino_acid_pairs(
  x = amino_acids(),
  y = amino_acids(),
  keep_self = TRUE,
  keep_duplicates = TRUE,
  keep_reverses = TRUE
)
}
\arguments{
\item{x}{A character vector of amino acids (three-letter codes).}

\item{y}{Another character vector of amino acids (three-letter codes).}

\item{keep_self}{Whether to keep pairs involving the same amino acid.}

\item{keep_duplicates}{Whether to keep duplicated pairs.}

\item{keep_reverses}{Whether to keep pairs that are reversed versions of
others. E.g. if \code{keep_reverses} is \code{TRUE} the pairs \code{"Ser"}-\code{"Arg"} and
\code{"Arg"}-\code{"Ser"} will be kept in the returned tibble; however, if
\code{keep_reverses} is \code{FALSE}, only the first pair is preserved in the output.}
}
\value{
A \link[tibble:tibble-package]{tibble} of amino acid pairs.
}
\description{
This function generates combinations of amino acids in pairs. By default, it
generates all pair combinations of the 20 standard amino acids.
}
\examples{
# Generate all pairs of the 20 standard amino acids
amino_acid_pairs()

# Remove the self-to-self pairs
amino_acid_pairs(keep_self = FALSE)

# Generate specific combinations of Ser against Ala and Trp.
amino_acid_pairs(x = 'Ser', y = c('Ala', 'Trp'))
}
