#' Plot quantile-quantile (QQ) graphs from residuals of linear models.
#'
#' This function takes a linear model (simple or mixed effects) and plots a QQ graph after running `augment` from \code{\link[broom.mixed]{augment}} to generate a table of model residuals on a saved ordinary (\code{\link{simple_model}}) or mixed model (\code{\link{mixed_model}} or \code{\link{mixed_model_slopes}}. The graph plots residuals from the model (sample) on Y axis & theoretical quantiles on X axis.
#'
#' The function uses \code{plot_qqline}, which relies on \code{stat_qq} and \code{stat_qq_line} geometries (get help with \code{?stat_qq_line}).
#'
#' @param Model name of a saved model generated by \code{simple_model} or \code{mixed_model}.
#'
#' @return This function returns a \code{ggplot2} object of class "gg" and "ggplot".
#' @export plot_qqmodel
#' @import ggplot2
#' @importFrom broom.mixed augment
#'
#' @examples
#' #Basic usage
#' m1 <- simple_model(data = data_2w_Festing, 
#' Y_value = "GST", 
#' Fixed_Factor = c("Treatment", "Strain"))
#' plot_qqmodel(m1)
#'

plot_qqmodel <- function(Model) {
    mod <- augment(Model)
    p <- plot_qqline(data = mod,
                     ycol = mod$`.resid`)
    suppressWarnings(print(p))
}

