% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradDescentR.SupportFunctions.R
\name{RMSE}
\alias{RMSE}
\title{RMSE Calculator Function}
\usage{
RMSE(outputData, prediction)
}
\arguments{
\item{outputData}{a data.frame represented dataset with output variable 
only (\eqn{m \times 1}), where \eqn{m} is the number of instances 
has one variable, which is the output.}

\item{prediction}{a data.frame represented prediction data with output 
variable only (\eqn{m \times 1}), where \eqn{m} is the number of
instances has one variable, which is the output.}
}
\value{
a float value represent the average error of the prediction
}
\description{
A function to calculate error using Root-Mean-Square-Error
}
\details{
This function used to calculate the error between two variables.
\code{outputData} is the first parameter of this function representing
the real output value. \code{prediction} is the second parameter of
this function representing the prediction value.
}
\examples{
 
################################## 
## Calculate Error using RMSE
## load R Package data  
data(gradDescentRData)
## get z-factor Data
dataSet <- gradDescentRData$CompressilbilityFactor
## do variance scaling to dataset
featureScalingResult <- varianceScaling(dataSet)
## split dataset
splitedDataSet <- splitData(featureScalingResult$scaledDataSet)
## built model using GD
model <- GD(splitedDataSet$dataTrain)
## separate testing data with input only
dataTestInput <- (splitedDataSet$dataTest)[,1:ncol(splitedDataSet$dataTest)-1]
## predict testing data using GD model
predictionData <- prediction(model, dataTestInput)
## calculate error using rmse
errorValue <- RMSE(splitedDataSet$dataTest[,ncol(splitedDataSet$dataTest)], 
predictionData[,ncol(predictionData)])
## show result
errorValue

}
