% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/btpermute.R
\name{btpermute}
\alias{btpermute}
\title{Variable selection with Permuted Inclusion Criterion}
\usage{
btpermute(
  contests = NULL,
  predictors = NULL,
  n.iterations = 15,
  seed = NULL,
  ...
)
}
\arguments{
\item{contests}{a data frame with pairwise binary contests with these variables
'id','player1','player2','win1','win2'; in that order. The id should be equivalent 
to the index of each row in \code{predictors}}

\item{predictors}{a data frame with player-specific variables with row indices that 
should match with the ids in \code{contests}. An id is not required, only the 
predictor variables, the ids are the index for each row}

\item{n.iterations}{integer, number of iterations to compute}

\item{seed}{integer, the seed for random number generation. If NULL (the default), 
\pkg{gosset} will set the seed randomly}

\item{...}{additional arguments passed to \pkg{BradleyTerry2} methods}
}
\value{
an object of class \code{gosset_btpermute} with the final \code{BTm()} model,
selected variables, seeds (random numbers) used for permutations and deviances
}
\description{
Method of forward variable selection based on deviance for Bradley-Terry
 models using pairwise ranking data. The selection procedure consists of two steps, 
 first, permuting the variables from the original \code{predictors} with 
 \code{n.iteractions}, then performing a forward selection to retain the
 \code{predictors} with highest contribution to the model, see details.
}
\details{
The selection procedure consists of two steps. In the first step, \code{btpermute} 
 adds to the set of original (candidate) \code{predictors} variables
 an additional set of 'fake', permuted variables. This set of permuted 
 \code{predictors} is created 
 by assigning to each ranking the variables from another, randomly selected 
 ranking. The permuted variables are not expected to have any predictive 
 power for pairwise rankings. In the second step, \code{btpermute} adds 
 predictors to the Bradley-Terry model in a forward selection procedure. 
 Each \code{predictors} (real and permuted) is added to the null model 
 individually, and \code{btpermute} retains which variable reduces model 
 deviance most strongly. The two-step process is replicated \code{n} times 
 with argument \code{n.iterations}. At each iteration, a new random permutation 
 is generated and all variables are tested. Replicability can be controlled 
 using argument \code{seed}. Across the n \code{n.iterations}, the function 
 identifies the predictor that appeared most often as the most deviance-reducing 
 one. When this is a real variable, it is constantly added to the model and 
 the forward selection procedure moves on – again creating new permutations, 
 adding real and fake variables individually, and examining model deviance. 
 Variable selection stops when a permuted variable is found to be most 
 frequently the most deviance-reducing \code{predictors} across \code{n.iterations}. 
 In turn, variable selection continuous as long as any real variable has stronger 
 explanatory power for pairwise rankings than the random variables.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

require("BradleyTerry2")

data("kenyachoice", package = "gosset")

mod <- btpermute(contests = kenyachoice$contests,
                 predictors = kenyachoice$predictors,
                 n.iterations = 10,
                 seed = 1)

mod
\dontshow{\}) # examplesIf}
}
\references{
Lysen, S. (2009) Permuted inclusion criterion: A variable selection technique. 
University of Pennsylvania
\url{https://repository.upenn.edu/edissertations/28/}
}
\seealso{
\code{\link{rank_binomial}}, \code{\link[BradleyTerry2]{BTm}}

Other model selection functions: 
\code{\link{crossvalidation}()}
}
\author{
Jonathan Steinke and Kauê de Sousa
}
\concept{model selection functions}
