% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Table_dofbypct.R
\name{Table_dofbypct}
\alias{Table_dofbypct}
\title{Noise Threshold Table}
\usage{
Table_dofbypct(doflist = NULL, pctlist = NULL, order = 4, ndecimals = 2,
  fitmetric = R2, trend = NULL, ...)
}
\arguments{
\item{doflist}{a vector of integers indicating the degrees of freedom}

\item{pctlist}{a vector of numbers between 0 and 1 standing for the percentile of noise}

\item{order}{a real number}

\item{ndecimals}{an integer}

\item{fitmetric}{a character string naming a standard fit metric (R2, rmse, or user)}

\item{trend}{a character string "Increasing", "Decreasing", "Flat", "Uncertain" which describes the general slope of the fitmetric function.}

\item{...}{any argument that functions within this routine might use}
}
\value{
a data frame
}
\description{
Constructs a table in the form of a data frame of threshold noise values for a given fit metric, a given set of possible degrees of freedom and a given set of percentiles
}
\examples{
Table_dofbypct(fitmetric=rmse)

}

