% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hector.R
\name{remove_outliers_hector}
\alias{remove_outliers_hector}
\title{Remove outliers from a gnssts object using Hector}
\usage{
remove_outliers_hector(x, n_seasonal, IQ_factor = 3, cleanup = TRUE)
}
\arguments{
\item{x}{A \code{gnssts} object}

\item{n_seasonal}{An \code{integer} specifying the number of seasonal component in the time series.}

\item{IQ_factor}{the \code{IQ_factor} parameter in hector removeoutliers.ctl}

\item{cleanup}{An \code{boolean} specifying if temporary files should be cleaned.}
}
\value{
A \code{gnssts} object.
}
\description{
Remove outliers from a gnssts object using Hector
}
\examples{
phase =     0.45
amplitude = 2.5
sigma2_wn =       15
bias =            0
trend =           5/365.25
cosU =            amplitude*cos(phase)
sinU =            amplitude*sin(phase)
n= 2*365
# define time at which there are jumps
jump_vec =  c(100, 200)
jump_height = c(10, 20)
# generate residuals
eps = rnorm(n = n, sd = sqrt(sigma2_wn))
# add trend, gaps and sin
A = create_A_matrix(1:length(eps), jump_vec, n_seasonal =  1)
# define beta
x_0 = c(bias, trend, jump_height,  cosU,  sinU)
# create time series
yy = A \%*\% x_0 + eps
plot(yy, type="l")
n_outliers = 30
set.seed(123)
id_outliers=sample(150:350, size = n_outliers)
val_outliers = rnorm(n = n_outliers, mean = max(yy)+10, sd = 5)
yy[id_outliers] = val_outliers
plot(yy, type="l")
# save signal in temp
gnssts_obj = create.gnssts(t = 1:length(yy), y = yy, jumps = jump_vec)
\dontrun{
clean_yy = remove_outliers_hector(x=gnssts_obj, n_seasonal = 1)
plot(clean_yy$t, clean_yy$y, type="l")
}
}
