% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wvcov.R
\name{wvcov}
\alias{wvcov}
\title{Calculate the Asymptotic Covariance Matrix}
\usage{
wvcov(signal.modwt, signal.wvar, compute.v = "diag")
}
\arguments{
\item{signal.modwt}{A \code{modwt} object that contains the modwt decomposition.}

\item{signal.wvar}{A \code{wvar} object that contains the wavelet variance.}

\item{compute.v}{A \code{string} that indicates the type of covariance matrix to compute. Supports: "diag"}
}
\value{
A \code{list} with the structure:
\describe{
  \item{"V"}{Covariance Matrix}
  \item{"V.r"}{Covariance Matrix}
  \item{"nlevels"}{Level of decomposition J}
  \item{"compute.v"}{Type of Covariance Matrix}
  \item{"robust"}{Robust active}
  \item{"eff"}{Efficiency level for Robust}
  \item{"scales"}{Tau scales (2^(1:J))}
  \item{"wv.empir"}{Empirical Wavelet Variance}
}
}
\description{
Places the Asymptotic Covariance Matrix in print form.
}
\examples{
set.seed(999)
x = rnorm(100)
decomp = modwt(x)
wv = wvar(x)
out = wvcov(decomp, wv, compute.v="diag")

# Robust
decomp = modwt(x)
wv = wvar(x, robust = TRUE)
out = wvcov(decomp, wv, compute.v="diag")
}
\author{
JJB
}

