% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wvar.R
\name{wvar}
\alias{wvar}
\alias{wvar.default}
\alias{wvar.gts}
\alias{wvar.imu}
\alias{wvar.lts}
\title{Wavelet Variance}
\usage{
wvar(x, ...)

\method{wvar}{lts}(x, decomp = "modwt", nlevels = NULL, alpha = 0.05,
  robust = FALSE, eff = 0.6, to.unit = NULL, ...)

\method{wvar}{gts}(x, decomp = "modwt", nlevels = NULL, alpha = 0.05,
  robust = FALSE, eff = 0.6, to.unit = NULL, ...)

\method{wvar}{default}(x, decomp = "modwt", nlevels = NULL, alpha = 0.05,
  robust = FALSE, eff = 0.6, freq = 1, from.unit = NULL,
  to.unit = NULL, ...)

\method{wvar}{imu}(x, decomp = "modwt", nlevels = NULL, alpha = 0.05,
  robust = F, eff = 0.6, to.unit = NULL, ...)
}
\arguments{
\item{x}{A \code{vector} with dimensions N x 1, or a \code{lts} object, or a \code{gts} object, or a \code{imu} object.}

\item{...}{Further arguments passed to or from other methods.}

\item{decomp}{A \code{string} that indicates whether to use the "dwt" or "modwt" decomposition.}

\item{nlevels}{An \code{integer} that indicates the level of decomposition. It must be less than or equal to floor(log2(length(x))).}

\item{alpha}{A \code{double} that indicates the \eqn{\left(1-p\right)*\alpha}{(1-p)*alpha} confidence level}

\item{robust}{A \code{boolean} that triggers the use of the robust estimate.}

\item{eff}{A \code{double} that indicates the efficiency as it relates to an MLE.}

\item{to.unit}{A \code{string} indicating the unit which the data is converted to.}

\item{freq}{A \code{numeric} that provides the rate of samples.}

\item{from.unit}{A \code{string} indicating the unit which the data is converted from.}
}
\value{
A \code{list} with the structure:
\describe{
  \item{"variance"}{Wavelet Variance}
  \item{"ci_low"}{Lower CI}
  \item{"ci_high"}{Upper CI}
  \item{"robust"}{Robust active}
  \item{"eff"}{Efficiency level for Robust}
  \item{"alpha"}{p value used for CI}
  \item{"unit"}{String representation of the unit}
}
}
\description{
Calculates the (MODWT) wavelet variance
}
\details{
If `nlevels` is not specified, it is set to floor(log2(length(x)))
}
\examples{
set.seed(999)
x = rnorm(100)
# Default
wvar(x)
# Robust
wvar(x, robust = TRUE, eff=0.3)
# 90\% confidence interval
wvar(x, alpha = 0.10)

# IMU Object
\dontrun{
if(!require("imudata")){
   install_imudata()
   library("imudata")
}

data(imu6)
test = imu(imu6, gyros = 1:3, accels = 4:6, freq = 100)
df = wvar.imu(test)
}
}
\author{
JJB
}

